/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	VariableRadiusBlending.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFeature.h"
#include "CApplication.h"


HRESULT VariableRadiusBlending(ISet *pEdge, VARIANT_BOOL bChamfer, VARIANT_BOOL bFlipped, VARIANT_BOOL bPropagate, VARIANT_BOOL bSmoothVariation, VARIANT_BOOL bGroupEdges, double *variableRadius, double *variableParams, int noOfVariableRadius, CString blendName, IBlend **pBlend) 
{
	//	Blends with the variable radius and return the newly created blend.

	START_METHOD("VariableRadiusBlending")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL; 
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	IBlend *blend = NULL;
	status = (GetCLASS(Blend))->CreateBlend(pDesign, CAST(IObjectOrSet, pEdge), FALSE, 1, variableRadius[0] ,1.0, &blend);
	CHECK_RETURN_STATUS(status)

	IOperation *operation = CAST(IOperation, blend);

	IBlend *blend1 = CAST(IBlend, blend);

	for(int i=0; i < noOfVariableRadius; i++) {
		status = blend1->SetVariableRadiusValue(variableParams[i], variableRadius[i], -1);
		CHECK_RETURN_STATUS(status)
	}

	status = operation->SetName(blendName.AllocSysString());
	CHECK_RETURN_STATUS(status)
	*pBlend = blend;

	END_METHOD("VariableRadiusBlending")
}
